/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan 
/* - Contents: α׷ A/D CH0,CH1,CH2 3ä Unlimited scan
/*     ̿Ͽ A/D convert ϰ 3ä  ͸ Ͽ ϴ ̴.
/*      Լ ĵ ۸  Access ʰ, COMI_US_RetrvChannel ()
/*     Ͽ ͸ Ѵ.
/*     * ϸ : C:\ComiUscan.txt
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define NUM_CH	3	/* Number of channels */
#define S_FREQ	5000	/* Scan freq. -> 5000 Hz */
#define MSB		40960	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */
#define CH_BUF_SIZE	1024 //   ũ  => ̰ ڰ  Ͽ  //
float Buffer[NUM_CH][CH_BUF_SIZE];
void main (void)
{
	HANDLE hDevice;
	int ch_list[NUM_CH] = {0, 1, 2};  /* Scan channel list : 0,1,2  ä */
	FILE *fp;
	ULONG prv_cnt=0, count;
	ULONG i;

	/* Load DLL */
	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	// Set A/D range //
	COMI_AD_SetRange(hDevice, 0, -10, 10);
	COMI_AD_SetRange(hDevice, 1, -10, 10);
	COMI_AD_SetRange(hDevice, 2, -10, 10);
	
	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	/* start unlimited scan */
	long act_freq = COMI_US_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_BLOCK);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!");
		printf("%s", COMI_ErrorString (COMI_LastError())); 
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
		exit(0);
	}

	/* Create a file to save data */
	/* Create a file to save data */
	if((fp = fopen ("c:\\ComiUscan.txt", "w")) == NULL){
		printf("͸     ϴ.\nƹŰ  ˴ϴ.\n");
		_getch();
		COMI_US_Stop (hDevice, TRUE);
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
	}
	fprintf (fp,"   CH0    CH1    CH2\n");
	prv_cnt = 0;
	while(!kbhit())
	{
		//  ä ĵ ͸ ´.					      //
		// prv_cnt Ŀ scan ͼ CH_BUF_SIZE     //
		//  scan ͱ ۿ ְ CH_BUF_SIZE  ũ   //
		// CH_BUF_SIZE ŭ ش.                               //
		COMI_US_RetrvChannel (hDevice, 0, prv_cnt+1, CH_BUF_SIZE, &Buffer[0], VT_FLOAT);
		COMI_US_RetrvChannel (hDevice, 1, prv_cnt+1, CH_BUF_SIZE, &Buffer[1], VT_FLOAT);
		count = COMI_US_RetrvChannel (hDevice, 2, prv_cnt+1, CH_BUF_SIZE, &Buffer[2], VT_FLOAT);
		if(count > 0){
			for(i=0; i<count; i++)
				fprintf (fp, "%6.2f %6.2f %6.2f\n", Buffer[0][i], Buffer[1][i], Buffer[2][i]);
			prv_cnt += count;
			printf("Number of saved data = %d\n", prv_cnt);
		}
	}
	
	COMI_US_Stop (hDevice, TRUE);
	fclose(fp);

	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
